@extends('installer.layout')

@section('title', 'License')
@section('subtitle', 'Enter your license key')

@section('content')
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">License Verification</h2>
    
    <p style="margin-bottom: var(--spacing-lg);">
        Please enter your license key to validate your purchase. If you don't have a license key, please contact support.
    </p>
    
    <form action="{{ route('installer.verify_license') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="license_key" class="form-label">License Key</label>
            <input type="text" id="license_key" name="license_key" class="form-control" value="{{ old('license_key') }}" placeholder="Enter your license key (e.g., XYZ-XXXX-XXXX-XXXX)" required>
            @if($errors->has('license_key'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('license_key') }}
                </div>
            @endif
        </div>
        
        <div style="margin-top: var(--spacing-lg); background-color: rgba(75, 139, 255, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-md); border: 1px solid rgba(75, 139, 255, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-info-circle" style="color: var(--primary-color); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <p style="font-size: 0.9rem; margin: 0;">
                    Your license key validates your purchase and enables access to updates and support. The license key should be in the format: XYZ-XXXX-XXXX-XXXX.
                </p>
            </div>
        </div>
    @endsection

    @section('footer')
        <a href="{{ route('installer.requirements') }}" class="btn">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-key"></i> Verify License
        </button>
    </form>
@endsection